package unipotsdam.informatikkiste;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;

/**
 * A Layout that can hold one Child View. It provides a 1:1 Ratio.
 * Created by rengel on 28.11.2017.
 */

public class SingleSquareLayout extends ViewGroup {


    public SingleSquareLayout(Context context) {
        super(context);
    }

    public SingleSquareLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SingleSquareLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();

        for(int i = 0; i < this.getChildCount(); i++){
            this.getChildAt(i).layout(0,0,width,height);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int size = Math.min(MeasureSpec.getSize(widthMeasureSpec),MeasureSpec.getSize(heightMeasureSpec));

        int width = MeasureSpec.makeMeasureSpec(size,MeasureSpec.EXACTLY);
        int height = widthMeasureSpec;
        this.setMeasuredDimension(width, height);

        for(int i = 0; i < this.getChildCount(); i++){
            this.getChildAt(i).measure(width,height);
        }
    }
}